// types/auth.ts
export interface AuthUser {
  id: number;
  email: string;
  role: "USER" | "ADMIN" | "MANAGER" | "CASHIER";
}

export interface JWTPayload {
  id: number;
  email: string;
  role: string;
  exp: number;
  iat?: number;
}

export type AuthContext = {
  user: AuthUser;
};

declare module "hono" {
  interface ContextVariableMap extends AuthContext {}
}
