import * as z from "zod";

/* ------------------------- USER SCHEMAS START ------------------------- */
export const registerSchema = z.object({
  email: z.email(),
  password: z.string().min(6, "Password must be at least 6 characters"),
  name: z.string().min(1),
  phone: z.string().min(5),
});

export const loginSchema = z.object({
  email: z.email({ error: "email is required hentai" }),
  password: z.string().min(1, "Password is required"),
});

export const updateProfileSchema = z.object({
  email: z.email().optional(),
  name: z.string().min(1).optional(),
  phone: z.string().min(5).optional(),
});

export const forgotPasswordSchema = z.object({
  email: z.email(),
});

export const resetPasswordSchema = z.object({
  token: z.uuid("Invalid token format"),
  newPassword: z.string().min(6, "Password must be at least 6 characters"),
});

export const updateRoleSchema = z.object({
  role: z.enum(["USER", "ADMIN"]),
});
/* ------------------------- USER SCHEMAS FINISH ------------------------- */
