#!/usr/bin/env node
"use strict";var m=require("@electric-sql/pglite");var p=require("net"),w=6e4,u=class u extends EventTarget{constructor(e){super();this.socket=null;this.active=!1;this.db=e.db,this.closeOnDetach=e.closeOnDetach??!1,this.inspect=e.inspect??!1,this.debug=e.debug??!1,this.id=u.nextHandlerId++,this.log("constructor: created new handler")}get handlerId(){return this.id}log(e,...t){this.debug&&console.log(`[PGLiteSocketHandler#${this.id}] ${e}`,...t)}async attach(e){if(this.log(`attach: attaching socket from ${e.remoteAddress}:${e.remotePort}`),this.socket)throw new Error("Socket already attached");return this.socket=e,this.active=!0,this.log("attach: waiting for PGlite to be ready"),await this.db.waitReady,this.log("attach: acquiring exclusive lock on PGlite instance"),await new Promise(t=>{this.db.runExclusive(()=>(t(),new Promise((n,i)=>{this.resolveLock=n,this.rejectLock=i})))}),this.log("attach: setting up socket event handlers"),e.on("data",t=>this.handleData(t)),e.on("error",t=>this.handleError(t)),e.on("close",()=>this.handleClose()),this}detach(e){return this.log(`detach: detaching socket, close=${e??this.closeOnDetach}`),this.socket?(this.socket.removeAllListeners("data"),this.socket.removeAllListeners("error"),this.socket.removeAllListeners("close"),(e??this.closeOnDetach)&&this.socket.writable&&(this.log("detach: closing socket"),this.socket.end()),this.log("detach: releasing exclusive lock on PGlite instance"),this.resolveLock?.(),this.socket=null,this.active=!1,this):(this.log("detach: no socket attached, nothing to do"),this)}get isAttached(){return this.socket!==null}async handleData(e){if(!this.socket||!this.active){this.log("handleData: no active socket, ignoring data");return}this.log(`handleData: received ${e.length} bytes`),this.inspectData("incoming",e);try{this.log("handleData: sending data to PGlite for processing");let t=await this.db.execProtocolRaw(new Uint8Array(e));this.log(`handleData: received ${t.length} bytes from PGlite`),this.inspectData("outgoing",t),this.socket&&this.socket.writable&&this.active?(this.log("handleData: writing response to socket"),this.socket.write(Buffer.from(t)),this.dispatchEvent(new CustomEvent("data",{detail:{incoming:e.length,outgoing:t.length}}))):this.log("handleData: socket no longer writable or active, discarding response")}catch(t){this.log("handleData: error processing data:",t),this.handleError(t)}}handleError(e){this.log("handleError:",e),this.dispatchEvent(new CustomEvent("error",{detail:e})),this.log("handleError: rejecting exclusive lock on PGlite instance"),this.rejectLock?.(e),this.resolveLock=void 0,this.rejectLock=void 0,this.detach(!0)}handleClose(){this.log("handleClose: socket closed"),this.dispatchEvent(new CustomEvent("close")),this.detach(!1)}inspectData(e,t){if(this.inspect){console.log("-".repeat(75)),console.log(e==="incoming"?"-> incoming":"<- outgoing",t.length,"bytes");for(let n=0;n<t.length;n+=16){let i=Math.min(16,t.length-n),c="";for(let o=0;o<16;o++)if(o<i){let s=t[n+o];c+=s.toString(16).padStart(2,"0")+" "}else c+="   ";let r="";for(let o=0;o<i;o++){let s=t[n+o];r+=s>=32&&s<=126?String.fromCharCode(s):"."}console.log(`${n.toString(16).padStart(8,"0")}  ${c} ${r}`)}}}};u.nextHandlerId=1;var v=u,d=class extends EventTarget{constructor(e){super();this.server=null;this.active=!1;this.activeHandler=null;this.connectionQueue=[];this.handlerCount=0;this.db=e.db,e.path?this.path=e.path:(this.port=e.port||5432,this.host=e.host||"127.0.0.1"),this.inspect=e.inspect??!1,this.debug=e.debug??!1,this.connectionQueueTimeout=e.connectionQueueTimeout??w,this.log(`constructor: created server on ${this.host}:${this.port}`),this.log(`constructor: connection queue timeout: ${this.connectionQueueTimeout}ms`)}log(e,...t){this.debug&&console.log(`[PGLiteSocketServer] ${e}`,...t)}async start(){if(this.log(`start: starting server on ${this.getServerConn()}`),this.server)throw new Error("Socket server already started");return this.active=!0,this.server=(0,p.createServer)(e=>this.handleConnection(e)),new Promise((e,t)=>{if(!this.server)return t(new Error("Server not initialized"));this.server.on("error",n=>{this.log("start: server error:",n),this.dispatchEvent(new CustomEvent("error",{detail:n})),t(n)}),this.path?this.server.listen(this.path,()=>{this.log(`start: server listening on ${this.getServerConn()}`),this.dispatchEvent(new CustomEvent("listening",{detail:{path:this.path}})),e()}):this.server.listen(this.port,this.host,()=>{this.log(`start: server listening on ${this.getServerConn()}`),this.dispatchEvent(new CustomEvent("listening",{detail:{port:this.port,host:this.host}})),e()})})}getServerConn(){return this.path?this.path:`${this.host}:${this.port}`}async stop(){return this.log("stop: stopping server"),this.active=!1,this.log(`stop: clearing connection queue (${this.connectionQueue.length} connections)`),this.connectionQueue.forEach(e=>{clearTimeout(e.timeoutId),e.socket.writable&&(this.log(`stop: closing queued connection from ${e.clientInfo.clientAddress}:${e.clientInfo.clientPort}`),e.socket.end())}),this.connectionQueue=[],this.activeHandler&&(this.log(`stop: detaching active handler #${this.activeHandlerId}`),this.activeHandler.detach(!0),this.activeHandler=null),this.server?new Promise(e=>{if(!this.server)return e();this.server.close(()=>{this.log("stop: server closed"),this.server=null,this.dispatchEvent(new CustomEvent("close")),e()})}):(this.log("stop: server not running, nothing to do"),Promise.resolve())}get activeHandlerId(){return this.activeHandler?.handlerId??null}async handleConnection(e){let t={clientAddress:e.remoteAddress||"unknown",clientPort:e.remotePort||0};if(this.log(`handleConnection: new connection from ${t.clientAddress}:${t.clientPort}`),!this.active){this.log("handleConnection: server not active, closing connection"),e.end();return}if(!this.activeHandler||!this.activeHandler.isAttached){this.log("handleConnection: no active handler, attaching socket directly"),this.dispatchEvent(new CustomEvent("connection",{detail:t})),await this.attachSocketToNewHandler(e,t);return}this.log(`handleConnection: active handler #${this.activeHandlerId} exists, queueing connection`),this.enqueueConnection(e,t)}enqueueConnection(e,t){this.log(`enqueueConnection: queueing connection from ${t.clientAddress}:${t.clientPort}, timeout: ${this.connectionQueueTimeout}ms`);let n=setTimeout(()=>{this.log(`enqueueConnection: timeout for connection from ${t.clientAddress}:${t.clientPort}`),this.connectionQueue=this.connectionQueue.filter(i=>i.socket!==e),e.writable&&(this.log("enqueueConnection: closing timed out connection"),e.end()),this.dispatchEvent(new CustomEvent("queueTimeout",{detail:{...t,queueSize:this.connectionQueue.length}}))},this.connectionQueueTimeout);this.connectionQueue.push({socket:e,clientInfo:t,timeoutId:n}),this.log(`enqueueConnection: connection queued, queue size: ${this.connectionQueue.length}`),this.dispatchEvent(new CustomEvent("queuedConnection",{detail:{...t,queueSize:this.connectionQueue.length}}))}processNextInQueue(){if(this.log(`processNextInQueue: processing next connection, queue size: ${this.connectionQueue.length}`),this.connectionQueue.length===0||!this.active){this.log("processNextInQueue: no connections in queue or server not active, nothing to do");return}let e=this.connectionQueue.shift();if(e){if(this.log(`processNextInQueue: processing connection from ${e.clientInfo.clientAddress}:${e.clientInfo.clientPort}`),clearTimeout(e.timeoutId),!e.socket.writable){this.log("processNextInQueue: socket no longer writable, skipping to next connection"),this.processNextInQueue();return}this.attachSocketToNewHandler(e.socket,e.clientInfo).catch(t=>{this.log("processNextInQueue: error attaching socket:",t),this.dispatchEvent(new CustomEvent("error",{detail:t})),this.processNextInQueue()})}}async attachSocketToNewHandler(e,t){this.handlerCount++,this.log(`attachSocketToNewHandler: creating new handler for ${t.clientAddress}:${t.clientPort} (handler #${this.handlerCount})`);let n=new v({db:this.db,closeOnDetach:!0,inspect:this.inspect,debug:this.debug});n.addEventListener("error",i=>{this.log(`handler #${n.handlerId}: error from handler:`,i.detail),this.dispatchEvent(new CustomEvent("error",{detail:i.detail}))}),n.addEventListener("close",()=>{this.log(`handler #${n.handlerId}: closed`),this.activeHandler===n&&(this.log(`handler #${n.handlerId}: was active handler, processing next connection in queue`),this.activeHandler=null,this.processNextInQueue())});try{this.activeHandler=n,this.log(`handler #${n.handlerId}: attaching socket`),await n.attach(e),this.dispatchEvent(new CustomEvent("connection",{detail:t}))}catch(i){throw this.log(`handler #${n.handlerId}: error attaching socket:`,i),this.activeHandler=null,e.writable&&e.end(),i}}};var b=require("util"),l=(0,b.parseArgs)({options:{db:{type:"string",short:"d",default:"memory://",help:"Database path (relative or absolute). Use memory:// for in-memory database."},port:{type:"string",short:"p",default:"5432",help:"Port to listen on"},host:{type:"string",short:"h",default:"127.0.0.1",help:"Host to bind to"},path:{type:"string",short:"u",default:void 0,help:"unix socket to bind to. Takes precedence over host:port"},debug:{type:"string",short:"v",default:"0",help:"Debug level (0-5)"},help:{type:"boolean",short:"?",default:!1,help:"Show help"}}}),E=`PGlite Socket Server
Usage: pglite-server [options]

Options:
  -d, --db=PATH       Database path (default: memory://)
  -p, --port=PORT     Port to listen on (default: 5432)
  -h, --host=HOST     Host to bind to (default: 127.0.0.1)
  -u, --path=UNIX     Unix socket to bind to (default: undefined). Takes precedence over host:port
  -v, --debug=LEVEL   Debug level 0-5 (default: 0)
`;l.values.help&&(console.log(E),process.exit(0));async function P(){try{let a=l.values.db,g=parseInt(l.values.port,10),e=l.values.host,t=l.values.path,n=l.values.debug,i=parseInt(n,10);console.log(`Initializing PGLite with database: ${a}`),console.log(`Debug level: ${i}`);let c=new m.PGlite(a,{debug:i});await c.waitReady,console.log("PGlite database initialized");let r=new d({db:c,port:g,host:e,path:t,inspect:i>0});r.addEventListener("listening",s=>{let h=s.detail;console.log(`PGLiteSocketServer listening on ${JSON.stringify(h)}`)}),r.addEventListener("connection",s=>{let{clientAddress:h,clientPort:f}=s.detail;console.log(`Client connected from ${h}:${f}`)}),r.addEventListener("error",s=>{let h=s.detail;console.error("Socket server error:",h)}),await r.start();let o=async()=>{console.log(`
Shutting down PGLiteSocketServer...`),await r.stop(),await c.close(),console.log("Server stopped"),process.exit(0)};process.on("SIGINT",o),process.on("SIGTERM",o)}catch(a){console.error("Failed to start PGLiteSocketServer:",a),process.exit(1)}}P().catch(a=>{console.error("Unhandled error:",a),process.exit(1)});
//# sourceMappingURL=server.cjs.map