
/* !!! This is code generated by Prisma. Do not edit directly. !!!
/* eslint-disable */
// biome-ignore-all lint: generated file

Object.defineProperty(exports, "__esModule", { value: true });

const {
  PrismaClientKnownRequestError,
  PrismaClientUnknownRequestError,
  PrismaClientRustPanicError,
  PrismaClientInitializationError,
  PrismaClientValidationError,
  getPrismaClient,
  sqltag,
  empty,
  join,
  raw,
  skip,
  Decimal,
  Debug,
  DbNull,
  JsonNull,
  AnyNull,
  NullTypes,
  makeStrictEnum,
  Extensions,
  warnOnce,
  defineDmmfProperty,
  Public,
  getRuntime,
  createParam,
} = require('./runtime/wasm-compiler-edge.js')


const Prisma = {}

exports.Prisma = Prisma
exports.$Enums = {}

/**
 * Prisma Client JS version: 7.0.0
 * Query Engine version: 0c19ccc313cf9911a90d99d2ac2eb0280c76c513
 */
Prisma.prismaVersion = {
  client: "7.0.0",
  engine: "0c19ccc313cf9911a90d99d2ac2eb0280c76c513"
}

Prisma.PrismaClientKnownRequestError = PrismaClientKnownRequestError;
Prisma.PrismaClientUnknownRequestError = PrismaClientUnknownRequestError
Prisma.PrismaClientRustPanicError = PrismaClientRustPanicError
Prisma.PrismaClientInitializationError = PrismaClientInitializationError
Prisma.PrismaClientValidationError = PrismaClientValidationError
Prisma.Decimal = Decimal

/**
 * Re-export of sql-template-tag
 */
Prisma.sql = sqltag
Prisma.empty = empty
Prisma.join = join
Prisma.raw = raw
Prisma.validator = Public.validator

/**
* Extensions
*/
Prisma.getExtensionContext = Extensions.getExtensionContext
Prisma.defineExtension = Extensions.defineExtension

/**
 * Shorthand utilities for JSON filtering
 */
Prisma.DbNull = DbNull
Prisma.JsonNull = JsonNull
Prisma.AnyNull = AnyNull

Prisma.NullTypes = NullTypes





/**
 * Enums
 */
exports.Prisma.TransactionIsolationLevel = makeStrictEnum({
  ReadUncommitted: 'ReadUncommitted',
  ReadCommitted: 'ReadCommitted',
  RepeatableRead: 'RepeatableRead',
  Serializable: 'Serializable'
});

exports.Prisma.UserScalarFieldEnum = {
  id: 'id',
  email: 'email',
  phone: 'phone',
  name: 'name',
  password: 'password',
  role: 'role',
  createdAt: 'createdAt',
  updatedAt: 'updatedAt'
};

exports.Prisma.SessionScalarFieldEnum = {
  id: 'id',
  userId: 'userId',
  expiresAt: 'expiresAt',
  createdAt: 'createdAt'
};

exports.Prisma.PasswordResetTokenScalarFieldEnum = {
  id: 'id',
  userId: 'userId',
  expiresAt: 'expiresAt',
  used: 'used'
};

exports.Prisma.BasketScalarFieldEnum = {
  id: 'id',
  userId: 'userId',
  createdAt: 'createdAt',
  updatedAt: 'updatedAt'
};

exports.Prisma.BasketItemScalarFieldEnum = {
  id: 'id',
  basketId: 'basketId',
  productId: 'productId',
  variantId: 'variantId',
  quantity: 'quantity',
  createdAt: 'createdAt',
  updatedAt: 'updatedAt'
};

exports.Prisma.CategoryScalarFieldEnum = {
  id: 'id',
  name: 'name',
  slug: 'slug',
  description: 'description',
  image: 'image',
  parentId: 'parentId',
  createdAt: 'createdAt',
  updatedAt: 'updatedAt'
};

exports.Prisma.ProductScalarFieldEnum = {
  id: 'id',
  name: 'name',
  slug: 'slug',
  description: 'description',
  sku: 'sku',
  price: 'price',
  discountPrice: 'discountPrice',
  status: 'status',
  barcode: 'barcode',
  categoryId: 'categoryId',
  createdAt: 'createdAt',
  updatedAt: 'updatedAt'
};

exports.Prisma.ProductImageScalarFieldEnum = {
  id: 'id',
  productId: 'productId',
  url: 'url',
  altText: 'altText',
  isPrimary: 'isPrimary',
  createdAt: 'createdAt',
  updatedAt: 'updatedAt'
};

exports.Prisma.ProductVariantScalarFieldEnum = {
  id: 'id',
  productId: 'productId',
  name: 'name',
  slug: 'slug',
  sku: 'sku',
  price: 'price',
  stock: 'stock',
  createdAt: 'createdAt',
  updatedAt: 'updatedAt'
};

exports.Prisma.AttributeScalarFieldEnum = {
  id: 'id',
  name: 'name',
  createdAt: 'createdAt',
  updatedAt: 'updatedAt'
};

exports.Prisma.AttributeValueScalarFieldEnum = {
  id: 'id',
  attributeId: 'attributeId',
  value: 'value',
  createdAt: 'createdAt',
  updatedAt: 'updatedAt'
};

exports.Prisma.ProductAttributeScalarFieldEnum = {
  id: 'id',
  productId: 'productId',
  attributeId: 'attributeId',
  attributeValueId: 'attributeValueId',
  createdAt: 'createdAt'
};

exports.Prisma.TagScalarFieldEnum = {
  id: 'id',
  name: 'name',
  createdAt: 'createdAt',
  updatedAt: 'updatedAt'
};

exports.Prisma.ProductTagScalarFieldEnum = {
  id: 'id',
  productId: 'productId',
  tagId: 'tagId',
  createdAt: 'createdAt'
};

exports.Prisma.OrderScalarFieldEnum = {
  id: 'id',
  orderNumber: 'orderNumber',
  userId: 'userId',
  status: 'status',
  totalAmount: 'totalAmount',
  discountAmount: 'discountAmount',
  taxAmount: 'taxAmount',
  shippingAmount: 'shippingAmount',
  finalAmount: 'finalAmount',
  currency: 'currency',
  shippingAddressId: 'shippingAddressId',
  billingAddressId: 'billingAddressId',
  createdAt: 'createdAt',
  updatedAt: 'updatedAt'
};

exports.Prisma.OrderItemScalarFieldEnum = {
  id: 'id',
  orderId: 'orderId',
  productId: 'productId',
  variantId: 'variantId',
  quantity: 'quantity',
  unitPrice: 'unitPrice',
  discountAmount: 'discountAmount',
  totalPrice: 'totalPrice',
  createdAt: 'createdAt',
  updatedAt: 'updatedAt'
};

exports.Prisma.PaymentScalarFieldEnum = {
  id: 'id',
  orderId: 'orderId',
  userId: 'userId',
  paymentMethod: 'paymentMethod',
  amount: 'amount',
  currency: 'currency',
  status: 'status',
  transactionId: 'transactionId',
  paymentIntentId: 'paymentIntentId',
  metadata: 'metadata',
  paidAt: 'paidAt',
  createdAt: 'createdAt',
  updatedAt: 'updatedAt'
};

exports.Prisma.AddressScalarFieldEnum = {
  id: 'id',
  userId: 'userId',
  firstName: 'firstName',
  lastName: 'lastName',
  company: 'company',
  addressLine1: 'addressLine1',
  addressLine2: 'addressLine2',
  city: 'city',
  state: 'state',
  postalCode: 'postalCode',
  country: 'country',
  phone: 'phone',
  isDefault: 'isDefault',
  createdAt: 'createdAt',
  updatedAt: 'updatedAt'
};

exports.Prisma.ReviewScalarFieldEnum = {
  id: 'id',
  userId: 'userId',
  productId: 'productId',
  rating: 'rating',
  title: 'title',
  comment: 'comment',
  isVerified: 'isVerified',
  createdAt: 'createdAt',
  updatedAt: 'updatedAt'
};

exports.Prisma.InventoryMovementScalarFieldEnum = {
  id: 'id',
  productId: 'productId',
  variantId: 'variantId',
  movementType: 'movementType',
  quantity: 'quantity',
  previousStock: 'previousStock',
  newStock: 'newStock',
  referenceId: 'referenceId',
  referenceType: 'referenceType',
  reason: 'reason',
  createdAt: 'createdAt'
};

exports.Prisma.WishlistScalarFieldEnum = {
  id: 'id',
  userId: 'userId',
  createdAt: 'createdAt',
  updatedAt: 'updatedAt'
};

exports.Prisma.WishlistItemScalarFieldEnum = {
  id: 'id',
  wishlistId: 'wishlistId',
  productId: 'productId',
  createdAt: 'createdAt'
};

exports.Prisma.SortOrder = {
  asc: 'asc',
  desc: 'desc'
};

exports.Prisma.NullableJsonNullValueInput = {
  DbNull: Prisma.DbNull,
  JsonNull: Prisma.JsonNull
};

exports.Prisma.QueryMode = {
  default: 'default',
  insensitive: 'insensitive'
};

exports.Prisma.NullsOrder = {
  first: 'first',
  last: 'last'
};

exports.Prisma.JsonNullValueFilter = {
  DbNull: Prisma.DbNull,
  JsonNull: Prisma.JsonNull,
  AnyNull: Prisma.AnyNull
};
exports.UserRole = exports.$Enums.UserRole = {
  USER: 'USER',
  ADMIN: 'ADMIN',
  MANAGER: 'MANAGER',
  CASHIER: 'CASHIER'
};

exports.ProductStatus = exports.$Enums.ProductStatus = {
  DRAFT: 'DRAFT',
  ACTIVE: 'ACTIVE',
  INACTIVE: 'INACTIVE',
  OUT_OF_STOCK: 'OUT_OF_STOCK',
  DISCONTINUED: 'DISCONTINUED'
};

exports.OrderStatus = exports.$Enums.OrderStatus = {
  PENDING: 'PENDING',
  CONFIRMED: 'CONFIRMED',
  PROCESSING: 'PROCESSING',
  SHIPPED: 'SHIPPED',
  DELIVERED: 'DELIVERED',
  CANCELLED: 'CANCELLED',
  REFUNDED: 'REFUNDED'
};

exports.PaymentStatus = exports.$Enums.PaymentStatus = {
  PENDING: 'PENDING',
  PROCESSING: 'PROCESSING',
  COMPLETED: 'COMPLETED',
  FAILED: 'FAILED',
  REFUNDED: 'REFUNDED',
  CANCELLED: 'CANCELLED'
};

exports.InventoryMovementType = exports.$Enums.InventoryMovementType = {
  PURCHASE: 'PURCHASE',
  SALE: 'SALE',
  RETURN: 'RETURN',
  ADJUSTMENT: 'ADJUSTMENT',
  TRANSFER: 'TRANSFER'
};

exports.Prisma.ModelName = {
  User: 'User',
  Session: 'Session',
  PasswordResetToken: 'PasswordResetToken',
  Basket: 'Basket',
  BasketItem: 'BasketItem',
  Category: 'Category',
  Product: 'Product',
  ProductImage: 'ProductImage',
  ProductVariant: 'ProductVariant',
  Attribute: 'Attribute',
  AttributeValue: 'AttributeValue',
  ProductAttribute: 'ProductAttribute',
  Tag: 'Tag',
  ProductTag: 'ProductTag',
  Order: 'Order',
  OrderItem: 'OrderItem',
  Payment: 'Payment',
  Address: 'Address',
  Review: 'Review',
  InventoryMovement: 'InventoryMovement',
  Wishlist: 'Wishlist',
  WishlistItem: 'WishlistItem'
};
/**
 * Create the Client
 */
const config = {
  "previewFeatures": [],
  "clientVersion": "7.0.0",
  "engineVersion": "0c19ccc313cf9911a90d99d2ac2eb0280c76c513",
  "activeProvider": "postgresql",
  "inlineSchema": "// This is your Prisma schema file,\n// learn more about it in the docs: https://pris.ly/d/prisma-schema\n\n// Looking for ways to speed up your queries, or scale easily with your serverless or edge functions?\n// Try Prisma Accelerate: https://pris.ly/cli/accelerate-init\ngenerator client {\n  provider = \"prisma-client-js\"\n  output   = \"../generated/prisma\"\n}\n\ndatasource db {\n  provider = \"postgresql\"\n}\n\nenum UserRole {\n  USER\n  ADMIN\n  MANAGER\n  CASHIER\n}\n\nenum ProductStatus {\n  DRAFT\n  ACTIVE\n  INACTIVE\n  OUT_OF_STOCK\n  DISCONTINUED\n}\n\nenum OrderStatus {\n  PENDING\n  CONFIRMED\n  PROCESSING\n  SHIPPED\n  DELIVERED\n  CANCELLED\n  REFUNDED\n}\n\nenum PaymentStatus {\n  PENDING\n  PROCESSING\n  COMPLETED\n  FAILED\n  REFUNDED\n  CANCELLED\n}\n\nenum InventoryMovementType {\n  PURCHASE\n  SALE\n  RETURN\n  ADJUSTMENT\n  TRANSFER\n}\n\nmodel User {\n  id        Int      @id @default(autoincrement())\n  email     String   @unique\n  phone     String?  @unique\n  name      String?\n  password  String\n  role      UserRole @default(USER)\n  createdAt DateTime @default(now())\n  updatedAt DateTime @updatedAt\n\n  // Relations\n  sessions            Session[]\n  passwordResetTokens PasswordResetToken[]\n  baskets             Basket[]\n  orders              Order[]\n  payments            Payment[]\n  addresses           Address[]\n  reviews             Review[]\n  wishlists           Wishlist[]\n\n  @@map(\"users\")\n}\n\nmodel Session {\n  id        String   @id @default(cuid())\n  userId    Int\n  user      User     @relation(fields: [userId], references: [id], onDelete: Cascade)\n  expiresAt DateTime\n  createdAt DateTime @default(now())\n\n  @@map(\"sessions\")\n}\n\nmodel PasswordResetToken {\n  id        String   @id @default(cuid())\n  userId    Int\n  user      User     @relation(fields: [userId], references: [id], onDelete: Cascade)\n  expiresAt DateTime\n  used      Boolean  @default(false)\n\n  @@map(\"password_reset_tokens\")\n}\n\nmodel Basket {\n  id        String       @id @default(cuid())\n  userId    Int\n  user      User         @relation(fields: [userId], references: [id], onDelete: Cascade)\n  items     BasketItem[]\n  createdAt DateTime     @default(now())\n  updatedAt DateTime     @updatedAt\n\n  @@map(\"baskets\")\n}\n\nmodel BasketItem {\n  id        String          @id @default(cuid())\n  basketId  String\n  basket    Basket          @relation(fields: [basketId], references: [id], onDelete: Cascade)\n  productId Int\n  product   Product         @relation(fields: [productId], references: [id], onDelete: Cascade)\n  variantId Int?\n  variant   ProductVariant? @relation(fields: [variantId], references: [id])\n  quantity  Int             @default(1)\n  createdAt DateTime        @default(now())\n  updatedAt DateTime        @updatedAt\n\n  @@unique([basketId, productId, variantId])\n  @@map(\"basket_items\")\n}\n\nmodel Category {\n  id          Int        @id @default(autoincrement())\n  name        String\n  slug        String     @unique\n  description String?\n  image       String?\n  parentId    Int?\n  parent      Category?  @relation(\"CategoryToCategory\", fields: [parentId], references: [id])\n  children    Category[] @relation(\"CategoryToCategory\")\n  products    Product[]\n  createdAt   DateTime   @default(now())\n  updatedAt   DateTime   @updatedAt\n\n  @@map(\"categories\")\n}\n\nmodel Product {\n  id            Int           @id @default(autoincrement())\n  name          String\n  slug          String        @unique\n  description   String?\n  sku           String?       @unique\n  price         Float         @default(0)\n  discountPrice Float?\n  status        ProductStatus @default(DRAFT)\n  barcode       String?       @unique\n  categoryId    Int\n  category      Category      @relation(fields: [categoryId], references: [id], onDelete: Cascade)\n\n  // Relations\n  images      ProductImage[]\n  variants    ProductVariant[]\n  attributes  ProductAttribute[]\n  tags        ProductTag[]\n  basketItems BasketItem[]\n  orderItems  OrderItem[]\n  reviews     Review[]\n  inventory   InventoryMovement[]\n\n  createdAt     DateTime       @default(now())\n  updatedAt     DateTime       @updatedAt\n  wishlistItems WishlistItem[]\n\n  @@map(\"products\")\n}\n\nmodel ProductImage {\n  id        Int      @id @default(autoincrement())\n  productId Int\n  product   Product  @relation(fields: [productId], references: [id], onDelete: Cascade)\n  url       String\n  altText   String?\n  isPrimary Boolean  @default(false)\n  createdAt DateTime @default(now())\n  updatedAt DateTime @updatedAt\n\n  @@map(\"product_images\")\n}\n\nmodel ProductVariant {\n  id        Int      @id @default(autoincrement())\n  productId Int\n  product   Product  @relation(fields: [productId], references: [id], onDelete: Cascade)\n  name      String\n  slug      String\n  sku       String?  @unique\n  price     Float?\n  stock     Int      @default(0)\n  createdAt DateTime @default(now())\n  updatedAt DateTime @updatedAt\n\n  // Relations\n  basketItems        BasketItem[]\n  orderItems         OrderItem[]\n  inventoryMovements InventoryMovement[]\n\n  @@unique([productId, name])\n  @@map(\"product_variants\")\n}\n\nmodel Attribute {\n  id        Int                @id @default(autoincrement())\n  name      String             @unique\n  values    AttributeValue[]\n  products  ProductAttribute[]\n  createdAt DateTime           @default(now())\n  updatedAt DateTime           @updatedAt\n\n  @@map(\"attributes\")\n}\n\nmodel AttributeValue {\n  id          Int                @id @default(autoincrement())\n  attributeId Int\n  attribute   Attribute          @relation(fields: [attributeId], references: [id], onDelete: Cascade)\n  value       String\n  products    ProductAttribute[]\n  createdAt   DateTime           @default(now())\n  updatedAt   DateTime           @updatedAt\n\n  @@unique([attributeId, value])\n  @@map(\"attribute_values\")\n}\n\nmodel ProductAttribute {\n  id               Int            @id @default(autoincrement())\n  productId        Int\n  product          Product        @relation(fields: [productId], references: [id], onDelete: Cascade)\n  attributeId      Int\n  attribute        Attribute      @relation(fields: [attributeId], references: [id], onDelete: Cascade)\n  attributeValueId Int\n  attributeValue   AttributeValue @relation(fields: [attributeValueId], references: [id], onDelete: Cascade)\n  createdAt        DateTime       @default(now())\n\n  @@unique([productId, attributeId, attributeValueId])\n  @@map(\"product_attributes\")\n}\n\nmodel Tag {\n  id        Int          @id @default(autoincrement())\n  name      String       @unique\n  products  ProductTag[]\n  createdAt DateTime     @default(now())\n  updatedAt DateTime     @updatedAt\n\n  @@map(\"tags\")\n}\n\nmodel ProductTag {\n  id        Int      @id @default(autoincrement())\n  productId Int\n  product   Product  @relation(fields: [productId], references: [id], onDelete: Cascade)\n  tagId     Int\n  tag       Tag      @relation(fields: [tagId], references: [id], onDelete: Cascade)\n  createdAt DateTime @default(now())\n\n  @@unique([productId, tagId])\n  @@map(\"product_tags\")\n}\n\nmodel Order {\n  id             String      @id @default(cuid())\n  orderNumber    String      @unique\n  userId         Int\n  user           User        @relation(fields: [userId], references: [id], onDelete: Cascade)\n  status         OrderStatus @default(PENDING)\n  totalAmount    Float       @default(0)\n  discountAmount Float       @default(0)\n  taxAmount      Float       @default(0)\n  shippingAmount Float       @default(0)\n  finalAmount    Float       @default(0)\n  currency       String      @default(\"USD\")\n\n  // Shipping information\n  shippingAddressId Int?\n  shippingAddress   Address? @relation(\"OrderShippingAddress\", fields: [shippingAddressId], references: [id])\n  billingAddressId  Int?\n  billingAddress    Address? @relation(\"OrderBillingAddress\", fields: [billingAddressId], references: [id])\n\n  // Relations\n  items    OrderItem[]\n  payments Payment[]\n\n  createdAt DateTime @default(now())\n  updatedAt DateTime @updatedAt\n\n  @@map(\"orders\")\n}\n\nmodel OrderItem {\n  id             String          @id @default(cuid())\n  orderId        String\n  order          Order           @relation(fields: [orderId], references: [id], onDelete: Cascade)\n  productId      Int\n  product        Product         @relation(fields: [productId], references: [id], onDelete: Cascade)\n  variantId      Int?\n  variant        ProductVariant? @relation(fields: [variantId], references: [id])\n  quantity       Int\n  unitPrice      Float\n  discountAmount Float           @default(0)\n  totalPrice     Float\n  createdAt      DateTime        @default(now())\n  updatedAt      DateTime        @updatedAt\n\n  @@map(\"order_items\")\n}\n\nmodel Payment {\n  id              String        @id @default(cuid())\n  orderId         String\n  order           Order         @relation(fields: [orderId], references: [id], onDelete: Cascade)\n  userId          Int\n  user            User          @relation(fields: [userId], references: [id], onDelete: Cascade)\n  paymentMethod   String // e.g., \"credit_card\", \"paypal\", \"stripe\"\n  amount          Float\n  currency        String        @default(\"USD\")\n  status          PaymentStatus @default(PENDING)\n  transactionId   String?       @unique\n  paymentIntentId String? // For Stripe or similar\n  metadata        Json? // Additional payment data\n  paidAt          DateTime?\n  createdAt       DateTime      @default(now())\n  updatedAt       DateTime      @updatedAt\n\n  @@map(\"payments\")\n}\n\nmodel Address {\n  id           Int     @id @default(autoincrement())\n  userId       Int\n  user         User    @relation(fields: [userId], references: [id], onDelete: Cascade)\n  firstName    String\n  lastName     String\n  company      String?\n  addressLine1 String\n  addressLine2 String?\n  city         String\n  state        String\n  postalCode   String\n  country      String  @default(\"US\")\n  phone        String?\n  isDefault    Boolean @default(false)\n\n  // Relations\n  shippingOrders Order[] @relation(\"OrderShippingAddress\")\n  billingOrders  Order[] @relation(\"OrderBillingAddress\")\n\n  createdAt DateTime @default(now())\n  updatedAt DateTime @updatedAt\n\n  @@map(\"addresses\")\n}\n\nmodel Review {\n  id         Int      @id @default(autoincrement())\n  userId     Int\n  user       User     @relation(fields: [userId], references: [id], onDelete: Cascade)\n  productId  Int\n  product    Product  @relation(fields: [productId], references: [id], onDelete: Cascade)\n  rating     Int // 1-5\n  title      String?\n  comment    String?\n  isVerified Boolean  @default(false)\n  createdAt  DateTime @default(now())\n  updatedAt  DateTime @updatedAt\n\n  @@unique([userId, productId])\n  @@map(\"reviews\")\n}\n\nmodel InventoryMovement {\n  id            Int                   @id @default(autoincrement())\n  productId     Int\n  product       Product               @relation(fields: [productId], references: [id], onDelete: Cascade)\n  variantId     Int?\n  variant       ProductVariant?       @relation(fields: [variantId], references: [id])\n  movementType  InventoryMovementType\n  quantity      Int\n  previousStock Int\n  newStock      Int\n  referenceId   String? // Order ID, Adjustment ID, etc.\n  referenceType String? // \"order\", \"adjustment\", etc.\n  reason        String?\n  createdAt     DateTime              @default(now())\n\n  @@map(\"inventory_movements\")\n}\n\nmodel Wishlist {\n  id        String         @id @default(cuid())\n  userId    Int\n  user      User           @relation(fields: [userId], references: [id], onDelete: Cascade)\n  items     WishlistItem[]\n  createdAt DateTime       @default(now())\n  updatedAt DateTime       @updatedAt\n\n  @@map(\"wishlists\")\n}\n\nmodel WishlistItem {\n  id         String   @id @default(cuid())\n  wishlistId String\n  wishlist   Wishlist @relation(fields: [wishlistId], references: [id], onDelete: Cascade)\n  productId  Int\n  product    Product  @relation(fields: [productId], references: [id], onDelete: Cascade)\n  createdAt  DateTime @default(now())\n\n  @@unique([wishlistId, productId])\n  @@map(\"wishlist_items\")\n}\n"
}

config.runtimeDataModel = JSON.parse("{\"models\":{\"User\":{\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"email\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"phone\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"name\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"password\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"role\",\"kind\":\"enum\",\"type\":\"UserRole\"},{\"name\":\"createdAt\",\"kind\":\"scalar\",\"type\":\"DateTime\"},{\"name\":\"updatedAt\",\"kind\":\"scalar\",\"type\":\"DateTime\"},{\"name\":\"sessions\",\"kind\":\"object\",\"type\":\"Session\",\"relationName\":\"SessionToUser\"},{\"name\":\"passwordResetTokens\",\"kind\":\"object\",\"type\":\"PasswordResetToken\",\"relationName\":\"PasswordResetTokenToUser\"},{\"name\":\"baskets\",\"kind\":\"object\",\"type\":\"Basket\",\"relationName\":\"BasketToUser\"},{\"name\":\"orders\",\"kind\":\"object\",\"type\":\"Order\",\"relationName\":\"OrderToUser\"},{\"name\":\"payments\",\"kind\":\"object\",\"type\":\"Payment\",\"relationName\":\"PaymentToUser\"},{\"name\":\"addresses\",\"kind\":\"object\",\"type\":\"Address\",\"relationName\":\"AddressToUser\"},{\"name\":\"reviews\",\"kind\":\"object\",\"type\":\"Review\",\"relationName\":\"ReviewToUser\"},{\"name\":\"wishlists\",\"kind\":\"object\",\"type\":\"Wishlist\",\"relationName\":\"UserToWishlist\"}],\"dbName\":\"users\"},\"Session\":{\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"userId\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"user\",\"kind\":\"object\",\"type\":\"User\",\"relationName\":\"SessionToUser\"},{\"name\":\"expiresAt\",\"kind\":\"scalar\",\"type\":\"DateTime\"},{\"name\":\"createdAt\",\"kind\":\"scalar\",\"type\":\"DateTime\"}],\"dbName\":\"sessions\"},\"PasswordResetToken\":{\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"userId\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"user\",\"kind\":\"object\",\"type\":\"User\",\"relationName\":\"PasswordResetTokenToUser\"},{\"name\":\"expiresAt\",\"kind\":\"scalar\",\"type\":\"DateTime\"},{\"name\":\"used\",\"kind\":\"scalar\",\"type\":\"Boolean\"}],\"dbName\":\"password_reset_tokens\"},\"Basket\":{\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"userId\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"user\",\"kind\":\"object\",\"type\":\"User\",\"relationName\":\"BasketToUser\"},{\"name\":\"items\",\"kind\":\"object\",\"type\":\"BasketItem\",\"relationName\":\"BasketToBasketItem\"},{\"name\":\"createdAt\",\"kind\":\"scalar\",\"type\":\"DateTime\"},{\"name\":\"updatedAt\",\"kind\":\"scalar\",\"type\":\"DateTime\"}],\"dbName\":\"baskets\"},\"BasketItem\":{\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"basketId\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"basket\",\"kind\":\"object\",\"type\":\"Basket\",\"relationName\":\"BasketToBasketItem\"},{\"name\":\"productId\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"product\",\"kind\":\"object\",\"type\":\"Product\",\"relationName\":\"BasketItemToProduct\"},{\"name\":\"variantId\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"variant\",\"kind\":\"object\",\"type\":\"ProductVariant\",\"relationName\":\"BasketItemToProductVariant\"},{\"name\":\"quantity\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"createdAt\",\"kind\":\"scalar\",\"type\":\"DateTime\"},{\"name\":\"updatedAt\",\"kind\":\"scalar\",\"type\":\"DateTime\"}],\"dbName\":\"basket_items\"},\"Category\":{\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"name\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"slug\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"description\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"image\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"parentId\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"parent\",\"kind\":\"object\",\"type\":\"Category\",\"relationName\":\"CategoryToCategory\"},{\"name\":\"children\",\"kind\":\"object\",\"type\":\"Category\",\"relationName\":\"CategoryToCategory\"},{\"name\":\"products\",\"kind\":\"object\",\"type\":\"Product\",\"relationName\":\"CategoryToProduct\"},{\"name\":\"createdAt\",\"kind\":\"scalar\",\"type\":\"DateTime\"},{\"name\":\"updatedAt\",\"kind\":\"scalar\",\"type\":\"DateTime\"}],\"dbName\":\"categories\"},\"Product\":{\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"name\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"slug\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"description\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"sku\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"price\",\"kind\":\"scalar\",\"type\":\"Float\"},{\"name\":\"discountPrice\",\"kind\":\"scalar\",\"type\":\"Float\"},{\"name\":\"status\",\"kind\":\"enum\",\"type\":\"ProductStatus\"},{\"name\":\"barcode\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"categoryId\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"category\",\"kind\":\"object\",\"type\":\"Category\",\"relationName\":\"CategoryToProduct\"},{\"name\":\"images\",\"kind\":\"object\",\"type\":\"ProductImage\",\"relationName\":\"ProductToProductImage\"},{\"name\":\"variants\",\"kind\":\"object\",\"type\":\"ProductVariant\",\"relationName\":\"ProductToProductVariant\"},{\"name\":\"attributes\",\"kind\":\"object\",\"type\":\"ProductAttribute\",\"relationName\":\"ProductToProductAttribute\"},{\"name\":\"tags\",\"kind\":\"object\",\"type\":\"ProductTag\",\"relationName\":\"ProductToProductTag\"},{\"name\":\"basketItems\",\"kind\":\"object\",\"type\":\"BasketItem\",\"relationName\":\"BasketItemToProduct\"},{\"name\":\"orderItems\",\"kind\":\"object\",\"type\":\"OrderItem\",\"relationName\":\"OrderItemToProduct\"},{\"name\":\"reviews\",\"kind\":\"object\",\"type\":\"Review\",\"relationName\":\"ProductToReview\"},{\"name\":\"inventory\",\"kind\":\"object\",\"type\":\"InventoryMovement\",\"relationName\":\"InventoryMovementToProduct\"},{\"name\":\"createdAt\",\"kind\":\"scalar\",\"type\":\"DateTime\"},{\"name\":\"updatedAt\",\"kind\":\"scalar\",\"type\":\"DateTime\"},{\"name\":\"wishlistItems\",\"kind\":\"object\",\"type\":\"WishlistItem\",\"relationName\":\"ProductToWishlistItem\"}],\"dbName\":\"products\"},\"ProductImage\":{\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"productId\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"product\",\"kind\":\"object\",\"type\":\"Product\",\"relationName\":\"ProductToProductImage\"},{\"name\":\"url\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"altText\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"isPrimary\",\"kind\":\"scalar\",\"type\":\"Boolean\"},{\"name\":\"createdAt\",\"kind\":\"scalar\",\"type\":\"DateTime\"},{\"name\":\"updatedAt\",\"kind\":\"scalar\",\"type\":\"DateTime\"}],\"dbName\":\"product_images\"},\"ProductVariant\":{\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"productId\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"product\",\"kind\":\"object\",\"type\":\"Product\",\"relationName\":\"ProductToProductVariant\"},{\"name\":\"name\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"slug\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"sku\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"price\",\"kind\":\"scalar\",\"type\":\"Float\"},{\"name\":\"stock\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"createdAt\",\"kind\":\"scalar\",\"type\":\"DateTime\"},{\"name\":\"updatedAt\",\"kind\":\"scalar\",\"type\":\"DateTime\"},{\"name\":\"basketItems\",\"kind\":\"object\",\"type\":\"BasketItem\",\"relationName\":\"BasketItemToProductVariant\"},{\"name\":\"orderItems\",\"kind\":\"object\",\"type\":\"OrderItem\",\"relationName\":\"OrderItemToProductVariant\"},{\"name\":\"inventoryMovements\",\"kind\":\"object\",\"type\":\"InventoryMovement\",\"relationName\":\"InventoryMovementToProductVariant\"}],\"dbName\":\"product_variants\"},\"Attribute\":{\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"name\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"values\",\"kind\":\"object\",\"type\":\"AttributeValue\",\"relationName\":\"AttributeToAttributeValue\"},{\"name\":\"products\",\"kind\":\"object\",\"type\":\"ProductAttribute\",\"relationName\":\"AttributeToProductAttribute\"},{\"name\":\"createdAt\",\"kind\":\"scalar\",\"type\":\"DateTime\"},{\"name\":\"updatedAt\",\"kind\":\"scalar\",\"type\":\"DateTime\"}],\"dbName\":\"attributes\"},\"AttributeValue\":{\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"attributeId\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"attribute\",\"kind\":\"object\",\"type\":\"Attribute\",\"relationName\":\"AttributeToAttributeValue\"},{\"name\":\"value\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"products\",\"kind\":\"object\",\"type\":\"ProductAttribute\",\"relationName\":\"AttributeValueToProductAttribute\"},{\"name\":\"createdAt\",\"kind\":\"scalar\",\"type\":\"DateTime\"},{\"name\":\"updatedAt\",\"kind\":\"scalar\",\"type\":\"DateTime\"}],\"dbName\":\"attribute_values\"},\"ProductAttribute\":{\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"productId\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"product\",\"kind\":\"object\",\"type\":\"Product\",\"relationName\":\"ProductToProductAttribute\"},{\"name\":\"attributeId\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"attribute\",\"kind\":\"object\",\"type\":\"Attribute\",\"relationName\":\"AttributeToProductAttribute\"},{\"name\":\"attributeValueId\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"attributeValue\",\"kind\":\"object\",\"type\":\"AttributeValue\",\"relationName\":\"AttributeValueToProductAttribute\"},{\"name\":\"createdAt\",\"kind\":\"scalar\",\"type\":\"DateTime\"}],\"dbName\":\"product_attributes\"},\"Tag\":{\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"name\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"products\",\"kind\":\"object\",\"type\":\"ProductTag\",\"relationName\":\"ProductTagToTag\"},{\"name\":\"createdAt\",\"kind\":\"scalar\",\"type\":\"DateTime\"},{\"name\":\"updatedAt\",\"kind\":\"scalar\",\"type\":\"DateTime\"}],\"dbName\":\"tags\"},\"ProductTag\":{\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"productId\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"product\",\"kind\":\"object\",\"type\":\"Product\",\"relationName\":\"ProductToProductTag\"},{\"name\":\"tagId\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"tag\",\"kind\":\"object\",\"type\":\"Tag\",\"relationName\":\"ProductTagToTag\"},{\"name\":\"createdAt\",\"kind\":\"scalar\",\"type\":\"DateTime\"}],\"dbName\":\"product_tags\"},\"Order\":{\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"orderNumber\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"userId\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"user\",\"kind\":\"object\",\"type\":\"User\",\"relationName\":\"OrderToUser\"},{\"name\":\"status\",\"kind\":\"enum\",\"type\":\"OrderStatus\"},{\"name\":\"totalAmount\",\"kind\":\"scalar\",\"type\":\"Float\"},{\"name\":\"discountAmount\",\"kind\":\"scalar\",\"type\":\"Float\"},{\"name\":\"taxAmount\",\"kind\":\"scalar\",\"type\":\"Float\"},{\"name\":\"shippingAmount\",\"kind\":\"scalar\",\"type\":\"Float\"},{\"name\":\"finalAmount\",\"kind\":\"scalar\",\"type\":\"Float\"},{\"name\":\"currency\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"shippingAddressId\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"shippingAddress\",\"kind\":\"object\",\"type\":\"Address\",\"relationName\":\"OrderShippingAddress\"},{\"name\":\"billingAddressId\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"billingAddress\",\"kind\":\"object\",\"type\":\"Address\",\"relationName\":\"OrderBillingAddress\"},{\"name\":\"items\",\"kind\":\"object\",\"type\":\"OrderItem\",\"relationName\":\"OrderToOrderItem\"},{\"name\":\"payments\",\"kind\":\"object\",\"type\":\"Payment\",\"relationName\":\"OrderToPayment\"},{\"name\":\"createdAt\",\"kind\":\"scalar\",\"type\":\"DateTime\"},{\"name\":\"updatedAt\",\"kind\":\"scalar\",\"type\":\"DateTime\"}],\"dbName\":\"orders\"},\"OrderItem\":{\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"orderId\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"order\",\"kind\":\"object\",\"type\":\"Order\",\"relationName\":\"OrderToOrderItem\"},{\"name\":\"productId\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"product\",\"kind\":\"object\",\"type\":\"Product\",\"relationName\":\"OrderItemToProduct\"},{\"name\":\"variantId\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"variant\",\"kind\":\"object\",\"type\":\"ProductVariant\",\"relationName\":\"OrderItemToProductVariant\"},{\"name\":\"quantity\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"unitPrice\",\"kind\":\"scalar\",\"type\":\"Float\"},{\"name\":\"discountAmount\",\"kind\":\"scalar\",\"type\":\"Float\"},{\"name\":\"totalPrice\",\"kind\":\"scalar\",\"type\":\"Float\"},{\"name\":\"createdAt\",\"kind\":\"scalar\",\"type\":\"DateTime\"},{\"name\":\"updatedAt\",\"kind\":\"scalar\",\"type\":\"DateTime\"}],\"dbName\":\"order_items\"},\"Payment\":{\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"orderId\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"order\",\"kind\":\"object\",\"type\":\"Order\",\"relationName\":\"OrderToPayment\"},{\"name\":\"userId\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"user\",\"kind\":\"object\",\"type\":\"User\",\"relationName\":\"PaymentToUser\"},{\"name\":\"paymentMethod\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"amount\",\"kind\":\"scalar\",\"type\":\"Float\"},{\"name\":\"currency\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"status\",\"kind\":\"enum\",\"type\":\"PaymentStatus\"},{\"name\":\"transactionId\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"paymentIntentId\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"metadata\",\"kind\":\"scalar\",\"type\":\"Json\"},{\"name\":\"paidAt\",\"kind\":\"scalar\",\"type\":\"DateTime\"},{\"name\":\"createdAt\",\"kind\":\"scalar\",\"type\":\"DateTime\"},{\"name\":\"updatedAt\",\"kind\":\"scalar\",\"type\":\"DateTime\"}],\"dbName\":\"payments\"},\"Address\":{\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"userId\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"user\",\"kind\":\"object\",\"type\":\"User\",\"relationName\":\"AddressToUser\"},{\"name\":\"firstName\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"lastName\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"company\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"addressLine1\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"addressLine2\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"city\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"state\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"postalCode\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"country\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"phone\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"isDefault\",\"kind\":\"scalar\",\"type\":\"Boolean\"},{\"name\":\"shippingOrders\",\"kind\":\"object\",\"type\":\"Order\",\"relationName\":\"OrderShippingAddress\"},{\"name\":\"billingOrders\",\"kind\":\"object\",\"type\":\"Order\",\"relationName\":\"OrderBillingAddress\"},{\"name\":\"createdAt\",\"kind\":\"scalar\",\"type\":\"DateTime\"},{\"name\":\"updatedAt\",\"kind\":\"scalar\",\"type\":\"DateTime\"}],\"dbName\":\"addresses\"},\"Review\":{\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"userId\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"user\",\"kind\":\"object\",\"type\":\"User\",\"relationName\":\"ReviewToUser\"},{\"name\":\"productId\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"product\",\"kind\":\"object\",\"type\":\"Product\",\"relationName\":\"ProductToReview\"},{\"name\":\"rating\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"title\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"comment\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"isVerified\",\"kind\":\"scalar\",\"type\":\"Boolean\"},{\"name\":\"createdAt\",\"kind\":\"scalar\",\"type\":\"DateTime\"},{\"name\":\"updatedAt\",\"kind\":\"scalar\",\"type\":\"DateTime\"}],\"dbName\":\"reviews\"},\"InventoryMovement\":{\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"productId\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"product\",\"kind\":\"object\",\"type\":\"Product\",\"relationName\":\"InventoryMovementToProduct\"},{\"name\":\"variantId\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"variant\",\"kind\":\"object\",\"type\":\"ProductVariant\",\"relationName\":\"InventoryMovementToProductVariant\"},{\"name\":\"movementType\",\"kind\":\"enum\",\"type\":\"InventoryMovementType\"},{\"name\":\"quantity\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"previousStock\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"newStock\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"referenceId\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"referenceType\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"reason\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"createdAt\",\"kind\":\"scalar\",\"type\":\"DateTime\"}],\"dbName\":\"inventory_movements\"},\"Wishlist\":{\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"userId\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"user\",\"kind\":\"object\",\"type\":\"User\",\"relationName\":\"UserToWishlist\"},{\"name\":\"items\",\"kind\":\"object\",\"type\":\"WishlistItem\",\"relationName\":\"WishlistToWishlistItem\"},{\"name\":\"createdAt\",\"kind\":\"scalar\",\"type\":\"DateTime\"},{\"name\":\"updatedAt\",\"kind\":\"scalar\",\"type\":\"DateTime\"}],\"dbName\":\"wishlists\"},\"WishlistItem\":{\"fields\":[{\"name\":\"id\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"wishlistId\",\"kind\":\"scalar\",\"type\":\"String\"},{\"name\":\"wishlist\",\"kind\":\"object\",\"type\":\"Wishlist\",\"relationName\":\"WishlistToWishlistItem\"},{\"name\":\"productId\",\"kind\":\"scalar\",\"type\":\"Int\"},{\"name\":\"product\",\"kind\":\"object\",\"type\":\"Product\",\"relationName\":\"ProductToWishlistItem\"},{\"name\":\"createdAt\",\"kind\":\"scalar\",\"type\":\"DateTime\"}],\"dbName\":\"wishlist_items\"}},\"enums\":{},\"types\":{}}")
defineDmmfProperty(exports.Prisma, config.runtimeDataModel)
config.compilerWasm = {
  getRuntime: async () => require('./query_compiler_bg.js'),
  getQueryCompilerWasmModule: async () => {
    const loader = (await import('#wasm-compiler-loader')).default
    const compiler = (await loader).default
    return compiler
  }
}
if (typeof globalThis !== 'undefined' && globalThis['DEBUG'] || (typeof process !== 'undefined' && process.env && process.env.DEBUG) || undefined) {
  Debug.enable(typeof globalThis !== 'undefined' && globalThis['DEBUG'] || (typeof process !== 'undefined' && process.env && process.env.DEBUG) || undefined)
}

const PrismaClient = getPrismaClient(config)
exports.PrismaClient = PrismaClient
Object.assign(exports, Prisma)
