import type { Config } from "../src/types/config.js";

export const config: Config = {
  env: process.env.NODE_ENV || "development",
  jwt: {
    secret: process.env.JWT_SECRET || "your-secret-key",
    expiresIn: 7 * 24 * 60 * 60, // 7 days
  },
  bcrypt: {
    rounds: 12,
  },
  resetToken: {
    expiresIn: 1 * 60 * 60 * 1000, // 1 hour
  },
  session: {
    expiresIn: 7 * 24 * 60 * 60 * 1000, // 7 days
  },
  database: {
    url: process.env.DATABASE_URL!,
  },
  uploads: {
    maxSize: 10 * 1024 * 1024, // 10MB
  },
} as const;
