export interface Config {
  env: string;
  jwt: {
    secret: string;
    expiresIn: number;
  };
  bcrypt: {
    rounds: number;
  };
  resetToken: {
    expiresIn: number;
  };
  session: {
    expiresIn: number;
  };
  database?: {
    url: string;
  };
  cors?: {
    allowedOrigins: string[];
  };
  rateLimit?: {
    windowMs: number;
    maxRequests: number;
  };
  email?: {
    from: string;
    smtp: {
      host: string;
      port: number;
      user: string;
      pass: string;
    };
  };
  uploads?: {
    maxSize: number;
  };
  logging?: {
    level: string;
    format: string;
  };
}
