// routes/public/index.ts
import withPrisma from "@/lib/prisma.js";
import type { ContextVars } from "@/types/contextVars.js";
import { Hono } from "hono";
import publicCategoriesRouter from "./categories.js";
import publicProductsRouter from "./products.js";

export const publicRouter = new Hono<ContextVars>();

publicRouter.use("*", withPrisma);

// Mount public routes
publicRouter.route("/products", publicProductsRouter);
publicRouter.route("/categories", publicCategoriesRouter);

// Public health check
publicRouter.get("/health", (c) => {
  return c.json({ status: "OK", timestamp: new Date().toISOString() });
});

export default publicRouter;
