import { swaggerUI } from "@hono/swagger-ui";
import { Hono } from "hono";

import { openApiDoc } from "@/data/doc.js";

const docRouter = new Hono();

// Serve the OpenAPI document
docRouter.get("/doc", (c) => c.json(openApiDoc));

// Use the middleware to serve Swagger UI at /ui
docRouter.get("/ui", swaggerUI({ url: "/docs/doc" }));

export default docRouter;
