import * as internal from "./internal/reloadable.js";
/**
 * @since 2.0.0
 * @category symbols
 */
export const ReloadableTypeId = internal.ReloadableTypeId;
/**
 * Makes a new reloadable service from a layer that describes the construction
 * of a static service. The service is automatically reloaded according to the
 * provided schedule.
 *
 * @since 2.0.0
 * @category constructors
 */
export const auto = internal.auto;
/**
 * Makes a new reloadable service from a layer that describes the construction
 * of a static service. The service is automatically reloaded according to a
 * schedule, which is extracted from the input to the layer.
 *
 * @since 2.0.0
 * @category constructors
 */
export const autoFromConfig = internal.autoFromConfig;
/**
 * Retrieves the current version of the reloadable service.
 *
 * @since 2.0.0
 * @category getters
 */
export const get = internal.get;
/**
 * Makes a new reloadable service from a layer that describes the construction
 * of a static service.
 *
 * @since 2.0.0
 * @category constructors
 */
export const manual = internal.manual;
/**
 * Reloads the specified service.
 *
 * @since 2.0.0
 * @category constructors
 */
export const reload = internal.reload;
/**
 * @since 2.0.0
 * @category context
 */
export const tag = internal.reloadableTag;
/**
 * Forks the reload of the service in the background, ignoring any errors.
 *
 * @since 2.0.0
 * @category constructors
 */
export const reloadFork = internal.reloadFork;
//# sourceMappingURL=Reloadable.js.map